<?php

namespace App\Controllers;

use App\Models\KelasModel;
use App\Models\GuruModel;
use App\Models\SiswaModel;

class KelasController extends BaseController
{
    public function index()
    {
        $model = new KelasModel();
        $data['kelas'] = $model->getKelasWithGuru(); // Mengambil data kelas dengan nama guru
        return view('dashboard/kelas/index', $data); // Menampilkan view kelas
    }
    
    public function tambah()
    {
        $guruModel = new GuruModel();
        $siswaModel = new SiswaModel();
        
        $data['guru'] = $guruModel->findAll(); // Mengambil semua data guru untuk dropdown
        $data['siswa'] = $siswaModel->findAll(); // Mengambil semua data siswa untuk dropdown
        
        return view('dashboard/kelas/create', $data); // Menampilkan view tambah kelas
    }


public function simpan()
{
    $model = new KelasModel();

    $data = [
        'id_guru' => $this->request->getPost('id_guru'),
        'nama_kelas' => $this->request->getPost('id_siswa'),
        'keterangan' => $this->request->getPost('keterangan'),
    ];

    $model->insert($data); // Simpan data kelas
    return redirect()->to('/data-kelas'); // Redirect ke halaman data kelas
}
public function edit($id_kelas)
{
    $model = new KelasModel();
    $data['kelas'] = $model->find($id_kelas); // Ambil data kelas berdasarkan ID

    $guruModel = new \App\Models\GuruModel();
    
    $data['guru'] = $guruModel->findAll(); // Ambil semua data guru untuk dropdown
    $siswaModel = new SiswaModel();
    $data['siswa'] = $siswaModel->findAll(); // Mengambil semua data siswa untuk dropdown

    return view('dashboard/kelas/edit', $data); // Menampilkan view edit kelas
}

public function update($id_kelas)
{
    $model = new KelasModel();

    $data = [
        'id_guru' => $this->request->getPost('id_guru'),
        'nama_kelas' => $this->request->getPost('nama_kelas'),
        'keterangan' => $this->request->getPost('keterangan'),
    ];

    $model->update($id_kelas, $data); // Update data kelas
    return redirect()->to('/data-kelas'); // Redirect ke halaman data kelas
}
public function hapus($id_kelas)
{
    $model = new KelasModel();
    $model->delete($id_kelas); // Hapus data kelas berdasarkan ID
    return redirect()->to('/data-kelas'); // Redirect ke halaman data kelas
}


}
