<?php

namespace App\Controllers;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use App\Models\PembayaranSppModel;
use App\Models\SiswaModel;
use Dompdf\Dompdf;
use Dompdf\Options;

class PembayaranSppController extends BaseController
{
    protected $pembayaranModel;
    protected $siswaModel;



    public function riwayat($id_siswa)
{
    $model = new PembayaranSppModel();
    $tahun = $this->request->getGet('tahun'); // Ambil tahun dari input form
    $riwayatPembayaran = $model->getRiwayatPembayaran($id_siswa, $tahun);

    if (empty($riwayatPembayaran)) {
        // Jika tidak ada data, set pesan error untuk ditampilkan
        session()->setFlashdata('error', 'Tidak ada riwayat pembayaran untuk tahun tersebut.');
    }

    return view('dashboard/Riwayat_spp/riwayat_pembayaran', [
        'riwayat_pembayaran' => $riwayatPembayaran,
        'id_siswa' => $id_siswa // Pastikan ID siswa dikirimkan ke view
    ]);
}

    

    public function riwayat1($id_siswa)
{
    // Ambil data riwayat pembayaran berdasarkan ID siswa
    $model = new PembayaranSppModel();
    $data['riwayat_pembayaran'] = $model->getPembayaranBySiswa($id_siswa);
    
    return view('dashboard/Riwayat_spp/riwayat_pembayaran', $data);
}


    public function __construct()
    {
        $this->pembayaranModel = new PembayaranSppModel();
        $this->siswaModel = new SiswaModel();
    }

    // Menampilkan daftar pembayaran SPP
    public function index()
    {
        $data['pembayaran_spp'] = $this->pembayaranModel->getPembayaranWithSiswa();   
        return view('dashboard/pembayaran_spp/index', $data);
    }

    public function search()
    {
        $nama = $this->request->getGet('nama');
        $tahun = $this->request->getGet('tahun');
        $bulan = $this->request->getGet('bulan');

        $model = new PembayaranSppModel();
        $data['pembayaran_spp'] = $model->searchPembayaran($nama, $tahun, $bulan); // pencarian data berdasarkan input

        return view('dashboard/pembayaran_spp/index', $data);// ganti dengan view Anda
    }

    // Menampilkan form tambah pembayaran
    public function create()
    {

        $data['siswa'] = $this->siswaModel->findAll(); // Mendapatkan data siswa untuk pilihan siswa
        return view('dashboard/pembayaran_spp/create', $data);
    }

    // Menyimpan data pembayaran
    public function store()
    {
        $this->pembayaranModel->save([
            'id_siswa' => $this->request->getPost('id_siswa'),
            'bulan' => $this->request->getPost('bulan'),
            'tahun' => $this->request->getPost('tahun'),
            'jumlah_pembayaran' => $this->request->getPost('jumlah_pembayaran'),
            'tanggal_pembayaran' => $this->request->getPost('tanggal_pembayaran'),
            'metode_pembayaran' => $this->request->getPost('metode_pembayaran'),
            'status' => $this->request->getPost('status'),
            'keterangan' => $this->request->getPost('keterangan')
        ]);
        return redirect()->to('pembayaran_spp')->with('message', 'Pembayaran SPP berhasil ditambahkan');
    }
    

    public function edit($id)
{
    // Ambil data pembayaran berdasarkan ID
    $data['pembayaran'] = $this->pembayaranModel->find($id);
    $data['siswa'] = $this->siswaModel->findAll(); // Ambil semua data siswa untuk dropdown

    return view('dashboard/pembayaran_spp/edit', $data);
}

public function update($id)
{
    $data = [
        'id_siswa' => $this->request->getPost('id_siswa'),
        'bulan' => $this->request->getPost('bulan'),
        'tahun' => $this->request->getPost('tahun'),
        'jumlah_pembayaran' => $this->request->getPost('jumlah_pembayaran'),
        'tanggal_pembayaran' => $this->request->getPost('tanggal_pembayaran'),
        'metode_pembayaran' => $this->request->getPost('metode_pembayaran'),
        'status' => $this->request->getPost('status'),
        'keterangan' => $this->request->getPost('keterangan'),
    ];

    // Update data pembayaran
    $this->pembayaranModel->update($id, $data);

    return redirect()->to(base_url('pembayaran_spp')); // Redirect setelah update
}
public function delete($id)
{
    // Hapus data pembayaran berdasarkan ID
    $this->pembayaranModel->delete($id);

    return redirect()->to(base_url('pembayaran_spp')); // Redirect setelah delete
}

// batas excel riwayat detil nama murid
public function exportExcel($id_siswa)
    {
        // Ambil data tahun dari request post atau form
        $tahun = $this->request->getPost('tahun'); // Dapatkan tahun dari form filter

        // Inisialisasi model
        $model = new PembayaranSppModel();

        // Ambil data pembayaran berdasarkan ID siswa dan tahun (jika ada)
        $dataPembayaran = $model->getRiwayatPembayaran($id_siswa, $tahun);

        if (empty($dataPembayaran)) {
            return redirect()->back()->with('error', 'Data pembayaran tidak ditemukan.');
        }

        // Buat instance Spreadsheet
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Set header kolom
        $sheet->setCellValue('A1', 'Nama Siswa');
        $sheet->setCellValue('B1', 'Tahun');
        $sheet->setCellValue('C1', 'Bulan');
        $sheet->setCellValue('D1', 'Tanggal Pembayaran');
        $sheet->setCellValue('E1', 'Jumlah Pembayaran');
        $sheet->setCellValue('F1', 'Status');
        $sheet->setCellValue('G1', 'Keterangan');

        // Isi data ke Excel
        $row = 2; // Baris dimulai dari 2 (1 untuk header)
        foreach ($dataPembayaran as $pembayaran) {
            $sheet->setCellValue('A' . $row, $pembayaran['nama_siswa']);
            $sheet->setCellValue('B' . $row, $pembayaran['tahun']);
            $sheet->setCellValue('C' . $row, $pembayaran['bulan']);
            $sheet->setCellValue('D' . $row, $pembayaran['tanggal_pembayaran']);
            $sheet->setCellValue('E' . $row, $pembayaran['jumlah_pembayaran']);
            $sheet->setCellValue('F' . $row, $pembayaran['status']);
            $sheet->setCellValue('G' . $row, $pembayaran['keterangan']);
            $row++;
        }

        // Atur nama file Excel
        $filename = 'Riwayat_Pembayaran_SPP_' . $id_siswa . '_' . $tahun . '.xlsx';

        // Kirim file Excel ke browser untuk diunduh
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // Buat writer Xlsx dan kirim ke browser
        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
        exit;
    }
// batas akhir excel riwayat detil nama murid

// batas pdf riwayat detil nama murid
public function exportPdf($id_siswa)
{
    // Ambil data tahun dari POST
    $tahun = $this->request->getPost('tahun');

    // Inisialisasi model
    $model = new PembayaranSppModel();

    // Ambil data pembayaran berdasarkan id_siswa dan tahun
    $dataPembayaran = $model->getRiwayatPembayaran($id_siswa, $tahun);

    if (empty($dataPembayaran)) {
        return redirect()->back()->with('error', 'Data pembayaran tidak ditemukan untuk tahun yang dipilih.');
    }

    // Load view ke dalam variable string
    $html = view('dashboard/Riwayat_spp/pdf_template', [
        'pembayaran' => $dataPembayaran,
        'tahun' => $tahun
    ]);

    // Konfigurasi Dompdf
    $options = new Options();
    $options->set('defaultFont', 'Courier');
    $dompdf = new Dompdf($options);

    // Load HTML ke Dompdf
    $dompdf->loadHtml($html);

    // (Opsional) Atur ukuran dan orientasi kertas
    $dompdf->setPaper('A4', 'portrait');

    // Render PDF
    $dompdf->render();

    // Output file PDF untuk di-download
    $dompdf->stream('Riwayat_Pembayaran_SPP_' . $id_siswa . '.pdf', ['Attachment' => 1]);
    exit();
}
// batas akhir pdf riwayat detil nama murid

// batas excel riwayat detil bagian pemayaran spp
public function export_excel()
{
    // Ambil input dari form (nama, bulan, tahun)
    $nama = $this->request->getPost('nama'); // Jika ada input nama siswa
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');

    // Inisialisasi model
    $model = new PembayaranSppModel();
    
    // Ambil data pembayaran berdasarkan filter (nama, bulan, tahun)
    $data = $model->searchPembayarann($nama, $tahun, $bulan);

    // Cek apakah data ditemukan
    if (empty($data)) {
        return redirect()->back()->with('error', 'Tidak ada data ditemukan');
    }

    // Buat spreadsheet baru
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Set header kolom
    $sheet->setCellValue('A1', 'ID');
    $sheet->setCellValue('B1', 'Nama Siswa');
    $sheet->setCellValue('C1', 'Bulan');
    $sheet->setCellValue('D1', 'Tahun');
    $sheet->setCellValue('E1', 'Jumlah Pembayaran');
    $sheet->setCellValue('F1', 'Tanggal Pembayaran');
    $sheet->setCellValue('G1', 'Metode Pembayaran');
    $sheet->setCellValue('H1', 'Status');
    $sheet->setCellValue('I1', 'Keterangan');

    // Isi data ke dalam spreadsheet
    $row = 2; // Mulai dari baris kedua
    foreach ($data as $pembayaran) {
        $sheet->setCellValue('A' . $row, $pembayaran['id_pembayaran']);
        $sheet->setCellValue('B' . $row, $pembayaran['nama_siswa']);
        $sheet->setCellValue('C' . $row, $pembayaran['bulan']);
        $sheet->setCellValue('D' . $row, $pembayaran['tahun']);
        $sheet->setCellValue('E' . $row, $pembayaran['jumlah_pembayaran']);
        $sheet->setCellValue('F' . $row, $pembayaran['tanggal_pembayaran']);
        $sheet->setCellValue('G' . $row, $pembayaran['metode_pembayaran']);
        $sheet->setCellValue('H' . $row, $pembayaran['status']);
        $sheet->setCellValue('I' . $row, $pembayaran['keterangan']);
        $row++;
    }

    // Buat file Excel
    $writer = new Xlsx($spreadsheet);
    $filename = 'pembayaran_spp_' . date('YmdHis') . '.xlsx';

    // Kirim file ke browser agar user bisa mendownload
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
    exit; // Hentikan script setelah file diekspor
}
// batas pdf riwayat detil bagian pemayaran spp
public function export_pdf()
{
    // Ambil data dari POST request
    $nama = $this->request->getPost('nama'); // Jika ada input nama siswa
    $bulan = $this->request->getPost('bulan');
    $tahun = $this->request->getPost('tahun');

    // Inisialisasi model
    $model = new PembayaranSppModel();

    // Ambil data pembayaran berdasarkan filter (nama, bulan, tahun)
    $data = $model->searchPembayaran($nama, $tahun, $bulan);

    // Cek apakah data ditemukan
    if (empty($data)) {
        return redirect()->back()->with('error', 'Tidak ada data ditemukan');
    }

    // Buat konten HTML untuk PDF dengan memuat view
    $html = view('dashboard/pembayaran_spp/pdf_template', ['data' => $data]);

    // Inisialisasi Dompdf
    $options = new Options();
    $options->set('defaultFont', 'Courier');
    $dompdf = new Dompdf($options);

    // Load HTML ke Dompdf
    $dompdf->loadHtml($html);

    // (Opsional) Set ukuran dan orientasi kertas
    $dompdf->setPaper('A4', 'landscape');

    // Render PDF
    $dompdf->render();

    // Kirim PDF ke browser
    $dompdf->stream('riwayat_pembayaran_spp.pdf', ['Attachment' => true]);
    exit; // Hentikan script setelah file diekspor
}


    // Method lain seperti edit, update, delete bisa ditambahkan di sini
}
