<?php
namespace App\Controllers;

use App\Models\UserModel;

class UserController extends BaseController
{
    public function editProfil()
    {
        $session = session();
        $userModel = new UserModel();
        
        // Ambil data user berdasarkan sesi
        $user = $userModel->find($session->get('id'));
        
        return view('dashboard/edit_profil', ['user' => $user]);
    }

    public function updateProfil()
    {
        $session = session();
        $userModel = new UserModel();

        // Validasi input
        $validation = $this->validate([
            'username' => 'required|min_length[4]|max_length[20]',
            'email' => 'required|valid_email',
            'password' => 'permit_empty|min_length[6]',
            'confirm_password' => 'matches[password]'
        ]);

        if (!$validation) {
            return redirect()->back()->withInput()->with('validation', $this->validator);
        }

        // Siapkan data yang akan diupdate
        $data = [
            'username' => $this->request->getPost('username'),
            'email' => $this->request->getPost('email'),
        ];

        // Jika password tidak kosong, update password
        if ($this->request->getPost('password')) {
            $data['password'] = password_hash($this->request->getPost('password'), PASSWORD_DEFAULT);
        }

        // Update data user berdasarkan ID dari sesi
        $userModel->update($session->get('id'), $data);

        // Redirect dengan pesan sukses
        return redirect()->to('dashboard/edit-profil')->with('success', 'Profil berhasil diperbarui.');
    }

    public function editpetugas()
    {
        $session = session();
        $userModel = new UserModel();
        
        // Ambil data user berdasarkan sesi
        $user = $userModel->find($session->get('id'));
        
        return view('dashboardpetugas/edit_profil', ['user' => $user]);
    }

    public function updatepetugas()
    {
        $session = session();
        $userModel = new UserModel();

        // Validasi input
        $validation = $this->validate([
            'username' => 'required|min_length[4]|max_length[20]',
            'email' => 'required|valid_email',
            'password' => 'permit_empty|min_length[6]',
            'confirm_password' => 'matches[password]'
        ]);

        if (!$validation) {
            return redirect()->back()->withInput()->with('validation', $this->validator);
        }

        // Siapkan data yang akan diupdate
        $data = [
            'username' => $this->request->getPost('username'),
            'email' => $this->request->getPost('email'),
        ];

        // Jika password tidak kosong, update password
        if ($this->request->getPost('password')) {
            $data['password'] = password_hash($this->request->getPost('password'), PASSWORD_DEFAULT);
        }

        // Update data user berdasarkan ID dari sesi
        $userModel->update($session->get('id'), $data);

        // Redirect dengan pesan sukses
        return redirect()->to('dashboardpetugas/edit-profil')->with('success', 'Profil berhasil diperbarui.');
    }

}
