<?php

namespace App\Models;

use CodeIgniter\Model;

class PenjualanBukuModel extends Model
{
    protected $table = 'penjualan_buku';
    protected $primaryKey = 'id_penjualan';
    protected $allowedFields = ['id_buku', 'jumlah_terjual', 'total_harga', 'tanggal_penjualan', 'keterangan'];
    
    // Jika perlu, tambahkan fungsi untuk mengambil data buku
    public function getPenjualan()
    {
        return $this->join('data_buku', 'penjualan_buku.id_buku = data_buku.id_buku')
                    ->select('penjualan_buku.*, data_buku.nama_buku')
                    ->findAll();
    }

    public function getPenjualanByDateRange($start_date, $end_date)
{
    return $this->select('penjualan_buku.*, data_buku.nama_buku')
                ->join('data_buku', 'penjualan_buku.id_buku = data_buku.id_buku')
                ->where('tanggal_penjualan >=', $start_date)
                ->where('tanggal_penjualan <=', $end_date)
                ->findAll();
}

public function getPenjualanByDate($tanggal_mulai, $tanggal_selesai)
{
    return $this->where('tanggal_penjualan >=', $tanggal_mulai)
                ->where('tanggal_penjualan <=', $tanggal_selesai)
                ->findAll();
}

public function getPenjualanBukuWithNamaBuku($start_date, $end_date)
    {
        return $this->db->table($this->table)
                        ->select('data_buku.nama_buku, penjualan_buku.*')
                        ->join('data_buku', 'data_buku.id_buku = penjualan_buku.id_buku')
                        ->where("tanggal_penjualan >=", $start_date)
                        ->where("tanggal_penjualan <=", $end_date)
                        ->get()
                        ->getResultArray();
    }

}
