<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"> <!-- Bootstrap CDN -->
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>"> <!-- Ganti dengan CSS Anda -->
    <style>
        body {
            background: linear-gradient(to right, #6a11cb, #2575fc); /* Gradien background */
            height: 100vh;
            display: flex;
            align-items: center; /* Memusatkan secara vertikal */
            justify-content: center; /* Memusatkan secara horizontal */
        }
        .card {
            width: 300px; /* Ukuran kotak login */
            padding: 20px; /* Padding dalam card */
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.3);
            text-align: center; /* Center text inside card */
        }
        .form-control {
            padding-left: 40px; /* Menambah padding untuk ikon */
        }
        .input-group-text {
            background: #f8f9fa; /* Warna latar belakang untuk ikon */
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h2>Login</h2>
            
            <?php if(session()->getFlashdata('msg')): ?>
                <div class="alert alert-danger"><?= session()->getFlashdata('msg') ?></div>
            <?php endif; ?>

            <form action="<?= base_url('auth/authenticate') ?>" method="post">
                <div class="form-group">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fas fa-user"></i></span> <!-- Ikon untuk username -->
                        </div>
                        <input type="text" class="form-control" name="username" id="username" placeholder="Username" required>
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fas fa-lock"></i></span> <!-- Ikon untuk password -->
                        </div>
                        <input type="password" class="form-control" name="password" id="password" placeholder="Password" required>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary btn-block">Login</button>
            </form>

            <!-- Tombol Register -->
            <div class="text-center mt-3">
                <p>Belum punya akun? <a href="<?= base_url('auth/register') ?>">Daftar di sini</a></p>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js"></script> <!-- Menambahkan Font Awesome untuk ikon -->
</body>
</html>
