<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
        <?= view('layouts/sidebarsuperadmin') ?>
                <!-- Content Wrapper -->
                <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                        <h1 class="mt-5">Data Guru</h1>
                        </div>
                    </div>
                </div>
            </div>
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">

                        <a href="<?= base_url('guru/tambah') ?>" class="btn btn-primary mb-3">Tambah Data</a>

        <!-- Tabel data siswa -->
        <div class="table-responsive border p-3">
                                    <table class="table table-striped table-bordered">
                                        <thead class="thead-dark">
                <tr>
                    <th>ID</th>
                    <th>Nama Guru</th>
                    <th>Tanggal Ulang Tahun</th>
                    <th>Instagram</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($guru) && is_array($guru)): ?>
                    <?php foreach ($guru as $g): ?>
                        <tr>
                            <td><?= esc($g['id_guru']) ?></td>
                            <td> <a href="<?= base_url('guru/detail/' . $g['id_guru']) ?>"> <?= esc($g['nama_guru']) ?></a></td>
                            <td><?= esc($g['tanggal_ulang_tahun']) ?></td>
                            <td><?= esc($g['instagram']) ?></td>
                            <td><a href="<?= base_url('guru/edit/' . $g['id_guru']) ?>" class="btn btn-warning btn-sm">Edit</a>
                            <a href="<?= base_url('guru/hapus/' . $g['id_guru']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">hapus</a></td>
                            
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" class="text-center">Data tidak ditemukan.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
                </div>

                        </div>
                    </div>
                </div>
            </section>
        </div>
        <!-- /.content-wrapper -->                   
    </div>
     <?php else: ?>
     <div class="alert alert-danger">
     <h4>Anda tidak memiliki akses ke halaman ini.</h4>
     </div>
    <?php endif; ?>
    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
    <!-- jQuery -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>


</body>
</html>
