<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
        <?= view('layouts/sidebarsuperadmin') ?>
                <!-- Content Wrapper -->
                <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="m-0">Laporan Akuntansi</h1>
                        </div>
                    </div>
                </div>
            </div>
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                        

<!-- Form Filter Berdasarkan Rentang Tanggal -->
<div class="border p-3 mb-3 rounded">
<form action="<?= base_url('laporan-akuntansi') ?>" method="get">
    <div class="form-row">
        <div class="form-group col-md-4">
            <label for="start_date">Tanggal Mulai</label>
            <input type="date" id="start_date" name="start_date" class="form-control" value="<?= esc($start_date) ?>" required>
        </div>
        <div class="form-group col-md-4">
            <label for="end_date">Tanggal Selesai</label>
            <input type="date" id="end_date" name="end_date" class="form-control" value="<?= esc($end_date) ?>" required>
        </div>
        <div class="form-group col-md-4 align-self-end">
            <button type="submit" class="btn btn-primary">Filter</button>
        </div>
    </div>
</form>
        </div>
<!-- Tambahkan Tombol Ekspor -->
<div class="mt-4">
<a href="<?= base_url('laporan-akuntansi/export-excel?start_date=' . $start_date . '&end_date=' . $end_date) ?>" class="btn btn-success">Ekspor ke Excel</a>
<a href="<?= base_url('laporan-akuntansi/export-pdf?start_date=' . $start_date . '&end_date=' . $end_date) ?>" class="btn btn-danger">Ekspor ke PDF</a>
</div>

<!-- Gabungan Pendapatan dan Pengeluaran dalam 1 Tabel -->

        
        <div class="table-responsive border p-3">
        <h5>Rincian Pendapatan dan Pengeluaran</h5>
        <table class="table table-striped table-bordered">
    <thead class="thead-dark">
        <tr>
            <th>Sumber</th>
            <th>Tanggal</th> <!-- Pindahkan kolom Tanggal di sini -->
            <th>Pendapatan (Rp)</th>
            <th>Pengeluaran (Rp)</th>
        </tr>
    </thead>
    <tbody>
        <!-- Rincian Pendapatan -->
        <?php foreach ($rincian_biaya_pendaftaran as $item): ?>
        <tr>
            <td>Biaya Pendaftaran - <?= esc($item['nama']) ?></td>
            <td><?= esc($item['tanggal_pendaftaran']) ?></td> <!-- Tampilkan tanggal pendaftaran -->
            <td>Rp.<?= number_format($item['biaya_pendaftaran'], 0, ',', '.') ?></td>
            <td></td>
        </tr>
        <?php endforeach; ?>
        
        <?php foreach ($rincian_pembayaran_spp as $item): ?>
        <tr>
            <td>Pembayaran SPP - Bulan <?= esc($item['bulan']) ?> - Nama <?= esc($item['nama']) ?></td>
            <td><?= esc($item['tanggal_pembayaran']) ?></td> <!-- Tampilkan tanggal pembayaran SPP -->
            <td>Rp.<?= number_format($item['jumlah_pembayaran'], 0, ',', '.') ?></td>
            <td></td>
        </tr>
        <?php endforeach; ?>

        <?php foreach ($rincian_penjualan_buku as $item): ?>
        <tr>
            <td>Penjualan Buku - <?= esc($item['nama_buku']) ?></td>
            <td><?= esc($item['tanggal_penjualan']) ?></td> <!-- Tampilkan tanggal penjualan buku -->
            <td>Rp.<?= number_format($item['total_harga'], 0, ',', '.') ?></td>
            <td></td>
        </tr>
        <?php endforeach; ?>

        <!-- Rincian Pengeluaran -->
        <?php foreach ($rincian_gaji as $item): ?>
        <tr>
            <td>Gaji Guru - <?= esc($item['nama_guru']) ?></td>
            <td><?= esc($item['tanggal_gajian']) ?></td> <!-- Tampilkan tanggal gaji -->
            <td></td>
            <td>Rp.<?= number_format($item['jumlah_gaji'], 0, ',', '.') ?></td>
        </tr>
        <?php endforeach; ?>

        <?php foreach ($rincian_pengeluaran as $item): ?>
        <tr>
            <td>Pengeluaran Barang - <?= esc($item['nama_barang']) ?></td>
            <td><?= esc($item['tanggal_beli']) ?></td> <!-- Tampilkan tanggal pembelian barang -->
            <td></td>
            <td>Rp.<?= number_format($item['harga'], 0, ',', '.') ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
    <tfoot>
        <tr>
            <th colspan="2">Total</th>
            <th>Rp.<?= number_format($total_pendapatan, 0, ',', '.') ?></th>
            <th>Rp.<?= number_format($total_pengeluaran_semua, 0, ',', '.') ?></th>
        </tr>
        <tr>
            <th colspan="3">Laba/Rugi</th>
            <th ><?= ($laba_rugi >= 0) ? 'Laba: ' : 'Rugi: ' ?>Rp. <?= number_format($laba_rugi, 0, ',', '.') ?></th>
        </tr>
    </tfoot>
</table>

                </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <!-- /.content-wrapper -->                   
    </div>
     <?php else: ?>
     <div class="alert alert-danger">
     <h4>Anda tidak memiliki akses ke halaman ini.</h4>
     </div>
    <?php endif; ?>
    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
    <!-- jQuery -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>


</body>
</html>
