<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
        <?= view('layouts/sidebarsuperadmin') ?>
                <!-- Content Wrapper -->
                <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                        <h1>Data Pembayaran Gaji Guru</h1>
                        </div>
                    </div>
                </div>
            </div>
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                                 <!-- Form Pencarian -->
        <div class="border p-3 mb-3 rounded">
            <form action="<?= base_url('pembayaran_gaji') ?>" method="get">
                <div class="row">
                    <div class="col-md-4">
                        <input type="text" name="nama_guru" class="form-control" placeholder="Cari Nama Guru" value="<?= esc($nama_guru) ?>">
                    </div>
                    <div class="col-md-3">
                        <input type="date" name="tanggal_mulai" class="form-control" placeholder="Tanggal Mulai" value="<?= esc($tanggal_mulai) ?>">
                    </div>
                    <div class="col-md-3">
                        <input type="date" name="tanggal_selesai" class="form-control" placeholder="Tanggal Selesai" value="<?= esc($tanggal_selesai) ?>">
                    </div>
                    <div class="col-md-2">
                        <button type="submit" class="btn btn-primary">Cari</button>
                    </div>
                </div>
            </form>
        </div>

        <div class="mb-3">
        <!-- Button to Add a New Gaji -->
        <a href="<?= base_url('pembayaran_gaji/tambah') ?>" class="btn btn-primary mb-3">Tambah Pembayaran Gaji</a>
        </div>
        <div class="mb-3">
           
            <!-- Tombol Ekspor -->
            <a href="<?= base_url('pembayaran_gaji/exportToExcel?' . http_build_query(['nama_guru' => $nama_guru, 'tanggal_mulai' => $tanggal_mulai, 'tanggal_selesai' => $tanggal_selesai])) ?>" class="btn btn-success">Export to Excel</a>
            <a href="<?= base_url('pembayaran_gaji/exportToPDF?' . http_build_query(['nama_guru' => $nama_guru, 'tanggal_mulai' => $tanggal_mulai, 'tanggal_selesai' => $tanggal_selesai])) ?>" class="btn btn-danger">Export to PDF</a>
        </div>

        <?php
        // Pengaturan Pagination
        $items_per_page = 12; // Jumlah item yang ditampilkan per halaman
        $total_items = count($pembayaran_gaji); // Total item
        $total_pages = ceil($total_items / $items_per_page); // Total halaman

        // Halaman saat ini (default adalah 1)
        $current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

        // Pastikan halaman saat ini dalam rentang yang valid
        if ($current_page < 1) $current_page = 1;
        if ($current_page > $total_pages) $current_page = $total_pages;

        // Hitung indeks awal untuk halaman saat ini
        $start_index = ($current_page - 1) * $items_per_page;

        // Batasi data yang ditampilkan untuk halaman saat ini
        $limited_pembayaran_gaji = array_slice($pembayaran_gaji, $start_index, $items_per_page);

        // Ambil query string saat ini (parameter GET) kecuali 'page' untuk menjaga parameter lainnya tetap utuh
        $queryString = $_SERVER['QUERY_STRING'];

        // Hapus parameter 'page' yang ada dari query string
        $queryString = preg_replace('/(\?|&)page=\d+/', '', $queryString);

        // Tambahkan '&' jika query string ada, atau mulai dengan '?'
        $queryString = ($queryString) ? '?' . $queryString . '&' : '?page=';
        ?>

        
                <div class="table-responsive border p-3">
                                    <table class="table table-striped table-bordered">
                                        <thead class="thead-dark">
                    <tr>
                        <th>ID</th>
                        <th>Nama Guru</th>
                        <th>Jumlah Gaji</th>
                        <th>Tanggal Gajian</th>
                        <th>Keterangan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($limited_pembayaran_gaji) && is_array($limited_pembayaran_gaji)): ?>
                        <?php foreach ($limited_pembayaran_gaji as $p): ?>
                            <tr>
                                <td><?= esc($p['id_pembayaran_gaji']) ?></td>
                                <td><?= esc($p['nama_guru']) ?></td>
                                <td>Rp <?= number_format(esc($p['jumlah_gaji']), 2, ',', '.') ?></td>
                                <td><?= esc($p['tanggal_gajian']) ?></td>
                                <td><?= esc($p['keterangan']) ?></td>
                                <td>
                                    <a href="<?= base_url('pembayaran_gaji/edit/' . $p['id_pembayaran_gaji']) ?>" class="btn btn-sm btn-warning">Edit</a>
                                    <a href="<?= base_url('pembayaran_gaji/hapus/' . $p['id_pembayaran_gaji']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Hapus</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">Data tidak ditemukan.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

            <nav aria-label="Navigasi halaman">
                <ul class="pagination justify-content-center">
                    <!-- Tombol Sebelumnya -->
                    <li class="page-item <?= ($current_page == 1) ? 'disabled' : '' ?>">
                        <a class="page-link" href="<?= $queryString ?>page=<?= $current_page - 1 ?>" aria-label="Sebelumnya">
                            <span aria-hidden="true">&laquo;</span>
                        </a>
                    </li>

                    <!-- Link Nomor Halaman -->
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?= ($current_page == $i) ? 'active' : '' ?>">
                            <a class="page-link" href="<?= $queryString ?>page=<?= $i ?>"><?= $i ?></a>
                        </li>
                    <?php endfor; ?>

                    <!-- Tombol Selanjutnya -->
                    <li class="page-item <?= ($current_page == $total_pages) ? 'disabled' : '' ?>">
                        <a class="page-link" href="<?= $queryString ?>page=<?= $current_page + 1 ?>" aria-label="Selanjutnya">
                            <span aria-hidden="true">&raquo;</span>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <!-- /.content-wrapper -->                   
    </div>
     <?php else: ?>
     <div class="alert alert-danger">
     <h4>Anda tidak memiliki akses ke halaman ini.</h4>
     </div>
    <?php endif; ?>
    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
    <!-- jQuery -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>


</body>
</html>
