<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Data Pembayaran Gaji Guru</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
    </style>
</head>
<body>
    <h1>Data Pembayaran Gaji Guru</h1>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Nama Guru</th>
                <th>Jumlah Gaji</th>
                <th>Tanggal Gajian</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($pembayaran_gaji) && is_array($pembayaran_gaji)): ?>
                <?php foreach ($pembayaran_gaji as $p): ?>
                    <tr>
                        <td><?= esc($p['id_pembayaran_gaji']) ?></td>
                        <td><?= esc($p['nama_guru']) ?></td>
                        <td>Rp <?= number_format($p['jumlah_gaji'], 0, ',', '.') ?></td>
                        <td><?= esc($p['tanggal_gajian']) ?></td>
                        <td><?= esc($p['keterangan']) ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5" class="text-center">Tidak ada data.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>
