<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Joy Course</title>

    <!-- Bootstrap & AdminLTE CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
    <!-- Wrapper -->
    <div class="wrapper">

        <!-- Navbar -->
        <?= view('layouts/navbar') ?>
        <!-- /.navbar -->

        <!-- bagian super admin -->
        <?php if (session()->get('role') === 'super admin'): ?>
        <?= view('layouts/sidebarsuperadmin') ?>
                <!-- Content Wrapper -->
                <div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-4">
                <div class="col-sm-6">
                    <h1 class="mt-4">Edit Pengeluaran</h1>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card shadow-sm">
                        <div class="card-header bg-info text-white">
                            <h4 class="mb-0">Form Edit Pengeluaran</h4>
                        </div>
                        <div class="card-body">
                        

<!-- Tampilkan pesan error jika ada -->
<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger">
        <?= session()->getFlashdata('error') ?>
    </div>
<?php endif; ?>

<!-- Form untuk mengedit pengeluaran -->
<form action="<?= base_url('pengeluaran/update/' . esc($pengeluaran['id_pengeluaran'])) ?>" method="post">
    <div class="form-group">
        <label for="nama_barang">Nama Barang</label>
        <input type="text" class="form-control" id="nama_barang" name="nama_barang" value="<?= esc($pengeluaran['nama_barang']) ?>" required>
    </div>
    <div class="form-group">
        <label for="toko">Toko</label>
        <input type="text" class="form-control" id="toko" name="toko" value="<?= esc($pengeluaran['toko']) ?>" required>
    </div>
    <div class="form-group">
        <label for="keterangan">Keterangan</label>
        <textarea class="form-control" id="keterangan" name="keterangan" rows="3"><?= esc($pengeluaran['keterangan']) ?></textarea>
    </div>
    <div class="form-group">
        <label for="jumlah">Jumlah</label>
        <input type="number" class="form-control" id="jumlah" name="jumlah" value="<?= esc($pengeluaran['jumlah']) ?>" required>
    </div>
    <div class="form-group">
        <label for="harga">Harga</label>
        <input type="number" class="form-control" id="harga" name="harga" value="<?= esc($pengeluaran['harga']) ?>" required>
    </div>
    <div class="form-group">
        <label for="tanggal_beli">Tanggal Beli</label>
        <input type="date" class="form-control" id="tanggal_beli" name="tanggal_beli" value="<?= esc($pengeluaran['tanggal_beli']) ?>" required>
    </div>

    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
    <a href="<?= base_url('pengeluaran') ?>" class="btn btn-secondary">Batal</a>
</form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

        <!-- /.content-wrapper -->                   
    </div>
     <?php else: ?>
     <div class="alert alert-danger">
     <h4>Anda tidak memiliki akses ke halaman ini.</h4>
     </div>
    <?php endif; ?>
    <!-- Bootstrap & AdminLTE JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.1.0/js/adminlte.min.js"></script>
    <!-- jQuery -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>


</body>
</html>
