<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Data Siswa</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        h2 {
            text-align: center;
        }
    </style>
</head>
<body>
    <h2>Data Siswa</h2>
    <table>
        <tr>
            <th>ID Siswa</th>
            <th>Nama</th>
            <th>Tanggal Lahir</th>
            <th>Nama Orang Tua</th>
            <th>Alamat</th>
            <th>No HP</th>
            <th>Akun Instagram</th>
            <th>Tanggal Pendaftaran</th>
            <th>Kelas</th>
            <th>Biaya Pendaftaran</th>
            <th>Status</th>
        </tr>
        <?php foreach ($data as $siswa): ?>
        <tr>
            <td><?= $siswa['id_siswa'] ?></td>
            <td><?= $siswa['nama'] ?></td>
            <td><?= date('d-m-Y', strtotime($siswa['tanggal_lahir'])) ?></td>
            <td><?= $siswa['nama_org_tua'] ?></td>
            <td><?= $siswa['alamat'] ?></td>
            <td><?= $siswa['no_hp'] ?></td>
            <td><?= $siswa['akun_instagram'] ?></td>
            <td><?= date('d-m-Y', strtotime($siswa['tanggal_pendaftaran'])) ?></td>
            <td><?= $siswa['kelas'] ?></td>
            <td>Rp <?= number_format($siswa['biaya_pendaftaran'], 0, ',', '.') ?></td>
            <td><?= $siswa['status'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
